/*
 *  Meals6.cpp
 *
 */

#include <iostream>
#include <string>

using namespace std;  //introduces namespace std

// Base meal class
class Meal
{
public:
  Meal():mainDish(""){}
  Meal(string argMainDish):mainDish(argMainDish){}
  Meal &operator=(Meal &m)
  {
    return assign(m);
  }
  
  virtual void setMainDish(string argMainDish)
  {
    mainDish = argMainDish;
  }
  
  virtual void printMenu();
  
  string getMainDish()
  {
    return mainDish; 
  }
protected:
  Meal &assign(Meal &m)
  {
    cout << "Assigning in Meal::" << endl;
    mainDish = m.getMainDish();
    return *this;
  }
  
private:
  string mainDish;
};

// Virutal member to print menu
void Meal::printMenu()
{
  cout << "we will be having " << mainDish << endl;
}


// DERIVED Breakfast class
// NOW WITH A VIRTUAL BASE CLASS!!
class Breakfast : virtual public Meal
{
public:
  Breakfast():Meal(){}
  Breakfast(string argMainDish):Meal(argMainDish){}
  
  Breakfast &operator=(Breakfast &b)
  {
    Meal::assign(b);
    return assign(b);
  }
  
  virtual void printMenu();
protected:
  Breakfast &assign(Breakfast &b)
  {
    cout << "Well, there's nothing to assign in Breakfast::" << endl;
    return *this;
  }
};

void Breakfast::printMenu()
{
  cout << "For BREAKFAST, ";
  Meal::printMenu();
}


// DERIVED Lunch class
// NOW WITH A VIRTUAL BASE CLASS!!
class Lunch : virtual public Meal
{
public:
  Lunch():Meal(){}
  Lunch(string argMainDish):Meal(argMainDish){}
  
  Lunch &operator=(Lunch &l)
  {
    Meal::assign(l);
    return assign(l);
  }
   virtual void printMenu();
protected:
  Lunch &assign(Lunch &l)
  {
    cout << "Well, there's nothing to assign in Lunch::" << endl;
    return *this;
  }

};

void Lunch::printMenu()
{
  cout << "For LUNCH, ";
  Meal::printMenu();
}


// MULTIPLY DERIVED Brunch class
class Brunch : public Breakfast, public Lunch
{
public:
  Brunch():Meal(){}
  Brunch(string argMainDish):Meal(argMainDish){}
  
  Brunch &operator=(Brunch &b)
  {
    Meal::assign(b);
    Breakfast::assign(b);
    Lunch::assign(b);
    return assign(b);
  }
  virtual void printMenu();

protected:
  Brunch &assign(Brunch &b)
  {
    cout << "Well, there's nothing to assign in Brunch::" << endl;
    return *this;
  }

};

void Brunch::printMenu()
{
  cout << "For BRUNCH, ";
  Meal::printMenu();
}

int main()
{	
  Brunch aBrunch("Scrambled Eggs");
  Brunch anotherBrunch;
  
  namespace foo = std;
  
  cout << "About to copy..." << endl;
  anotherBrunch = aBrunch;
//  aBrunch.printMenu();
  return 0;
}

